export function typeOf (value): string {
  if (Array.isArray(value)) {
    return 'array';
  }

  if (value instanceof Date) {
    return 'date';
  }

  if (value instanceof Error) {
    return 'error';
  }

  if (value instanceof RegExp) {
    return 'regexp';
  }

  if (value === null) {
    return 'null';
  }

  if (
    typeof value === 'object'
    && Object.prototype.toString.call(value) === '[object Object]'
  ) {
    return 'object';
  }

  return typeof value;
}
